<?php
session_start();
include 'conexao.php';

// Verifica se o aluno está logado
if (!isset($_SESSION['aluno'])) {
    header("Location: login_aluno.php");
    exit;
}

$aluno_logado = $_SESSION['aluno'];
$aluno_id = $aluno_logado['id'];
$turma_id = $aluno_logado['turma_id'];

// Seleção do ano letivo pelo aluno (opcional)
$ano_letivo = $_POST['ano_letivo'] ?? '';

// Busca todos os anos letivos em que o aluno possui notas
$anos_letivos = [];
$stmt_anos = $conn->prepare("SELECT DISTINCT ano_lectivo FROM notas WHERE aluno_id = ? ORDER BY ano_lectivo DESC");
$stmt_anos->bind_param("i", $aluno_id);
$stmt_anos->execute();
$res_anos = $stmt_anos->get_result();
while ($row = $res_anos->fetch_assoc()) {
    $anos_letivos[] = $row['ano_lectivo'];
}
$stmt_anos->close();

// Se nenhum ano for selecionado, pega o mais recente
if ($ano_letivo == '' && !empty($anos_letivos)) {
    $ano_letivo = $anos_letivos[0];
}

// Inicializa variáveis
$notas_organizadas = [];

// Busca notas do aluno logado
if ($ano_letivo != '') {
    $stmt = $conn->prepare("
        SELECT d.nome AS disciplina_nome, n.*
        FROM notas n
        JOIN disciplinas d ON n.disciplina_id = d.id
        WHERE n.aluno_id = ? AND n.turma_id = ? AND n.ano_lectivo = ?
        ORDER BY d.nome, n.trimestre
    ");
    $stmt->bind_param("iis", $aluno_id, $turma_id, $ano_letivo);
    $stmt->execute();
    $notas_raw = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    $stmt->close();

    // Organiza as notas
    foreach ($notas_raw as $nota) {
        $disc = $nota['disciplina_nome'];
        $tri = $nota['trimestre'];
        if (!isset($notas_organizadas[$disc])) {
            $notas_organizadas[$disc] = [
                'trimestres'=>[
                    1=>['av1'=>null,'av2'=>null,'av3'=>null,'mt'=>null],
                    2=>['av1'=>null,'av2'=>null,'av3'=>null,'mt'=>null],
                    3=>['av1'=>null,'av2'=>null,'av3'=>null,'mt'=>null]
                ],
                'exame'=>null,
                'mfd'=>null
            ];
        }
        $notas_organizadas[$disc]['trimestres'][$tri]['av1']=$nota['av1'];
        $notas_organizadas[$disc]['trimestres'][$tri]['av2']=$nota['av2'];
        $notas_organizadas[$disc]['trimestres'][$tri]['av3']=$nota['av3'];
        $avs = array_filter([$nota['av1'],$nota['av2'],$nota['av3']], fn($v)=>$v!==null);
        $mt_val = !empty($avs)? round(array_sum($avs)/count($avs),1):null;
        $notas_organizadas[$disc]['trimestres'][$tri]['mt'] = $mt_val;
        if(isset($nota['exame'])) $notas_organizadas[$disc]['exame'] = $nota['exame'];
    }

    // Calcula MFD
    foreach ($notas_organizadas as &$disciplina) {
        $soma_mt=0; $count_mt=0;
        foreach($disciplina['trimestres'] as $t){
            if($t['mt']!==null){$soma_mt+=$t['mt']; $count_mt++;}
        }
        $disciplina['mfd'] = $count_mt>0? round($soma_mt/$count_mt,1):null;
    }
    unset($disciplina);
}
?>

<!DOCTYPE html>
<html lang="pt">
<head>
<meta charset="UTF-8">
<title>Pauta do Aluno - <?= htmlspecialchars($aluno_logado['nome']) ?></title>
<style>
body{font-family:Arial,sans-serif; background:#f0f2f5; margin:0; padding:20px;}
.panel{background:#fff; padding:15px; border-radius:8px; box-shadow:0 2px 6px rgba(0,0,0,0.15); margin-bottom:20px;}
select,button{padding:5px 8px;margin:5px; border-radius:4px; border:1px solid #ccc;}
button{background:#007bff; color:#fff; border:none; cursor:pointer;}
button:hover{background:#0056b3;}
table{border-collapse:collapse;width:95%; max-width:800px; margin-top:10px;}
th,td{border:1px solid #ccc; padding:4px; text-align:center;}
th{background:#007bff;color:#fff;font-size:12px;}
td{font-size:12px;}
td.nome-aluno{width:180px; text-align:left; padding-left:6px;}
.nota-baixa{color:red;font-weight:600;}
</style>
</head>
<body>

<div class="panel">
    <h2>Consulta de Notas - <?= htmlspecialchars($aluno_logado['nome']) ?></h2>
    <form method="post">
        <label>Ano Lectivo:</label>
        <select name="ano_letivo" onchange="this.form.submit()">
            <?php foreach($anos_letivos as $ano): ?>
                <option value="<?= $ano ?>" <?= ($ano==$ano_letivo)?'selected':'' ?>><?= $ano ?></option>
            <?php endforeach; ?>
        </select>
    </form>
</div>

<?php if(!empty($notas_organizadas)): ?>
<div class="panel">
    <table>
        <thead>
            <tr>
                <th rowspan="2">Disciplina</th>
                <th colspan="4">1º Trimestre</th>
                <th colspan="4">2º Trimestre</th>
                <th colspan="4">3º Trimestre</th>
                <th>Exame</th>
                <th>MF</th>
            </tr>
            <tr>
                <th>AV1</th><th>AV2</th><th>AV3</th><th>MT1</th>
                <th>AV1</th><th>AV2</th><th>AV3</th><th>MT2</th>
                <th>AV1</th><th>AV2</th><th>AV3</th><th>MT3</th>
                <th></th><th></th>
            </tr>
        </thead>
        <tbody>
        <?php foreach($notas_organizadas as $disc=>$d): ?>
            <tr>
                <td><?= htmlspecialchars($disc) ?></td>
                <?php for($i=1;$i<=3;$i++):
                    $t=$d['trimestres'][$i]; ?>
                    <td><?= $t['av1']??'-' ?></td>
                    <td><?= $t['av2']??'-' ?></td>
                    <td><?= $t['av3']??'-' ?></td>
                    <td class="<?= ($t['mt']!==null && $t['mt']<10)?'nota-baixa':'' ?>"><?= $t['mt']??'-' ?></td>
                <?php endfor; ?>
                <td><?= $d['exame']??'-' ?></td>
                <td class="<?= ($d['mfd']!==null && $d['mfd']<10)?'nota-baixa':'' ?>"><?= round($d['mfd'])??'-' ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
<?php else: ?>
<div class="panel">
    <p>Nenhuma nota encontrada para o ano lectivo selecionado.</p>
</div>
<?php endif; ?>

</body>
</html>
